#include <Arduino.h>
#include <VirtualWire.h>
#include "gg433mhz.h"

gg433mhz::gg433mhz()
{
}

void gg433mhz::startReceiver(byte pin_rx, int bauds)
{
  vw_set_rx_pin(pin_rx);
  vw_set_ptt_inverted(true); // Required for DR3100
  vw_setup(bauds);   // Bits per sec
  vw_rx_start();       // Start the receiver PLL running
}

int gg433mhz::getMaxMessageLength()
{
  return VW_MAX_MESSAGE_LEN;
}

boolean gg433mhz::receiveMessage(char msg[])
{
  uint8_t buf[VW_MAX_MESSAGE_LEN];
  uint8_t buflen = VW_MAX_MESSAGE_LEN;
  int i;
  if (vw_get_message(buf, &buflen) == false)return false; // Non-blocking
  for (i = 0; i < buflen; i++) msg[i] = (char)buf[i];
    msg[buflen] = 0;
    return true;
 }

 void gg433mhz::startTransmitter(byte pin_tx, int bauds)
 {  
  vw_set_tx_pin(pin_tx);
  vw_set_ptt_inverted(true); // Required for DR3100
  vw_setup(bauds);   // Bits per sec
 }

 void gg433mhz::sendMessage(char msg[])
 {
  vw_send((uint8_t *)msg,strlen(msg));
  vw_wait_tx();
 }
