#ifndef __ggtm1637__
#define __ggtm1637__

#include <inttypes.h>
#include <arduino.h>
#define SEG_A   0b00000001
#define SEG_B   0b00000010
#define SEG_C   0b00000100
#define SEG_D   0b00001000
#define SEG_E   0b00010000
#define SEG_F   0b00100000
#define SEG_G   0b01000000

class ggtm1637 
{
 public:
 /** Definit un module tm1637 module en specifiant les broches clock and data.*/
  ggtm1637(uint8_t pinClk, uint8_t pinDIO);
 /** Affiche un segment sur l'afficheur specifie
 * pos : numero de l'afficheur 0 (le plus a gauche) a 3 (le plus a droite)
 * seg : numero de segment de 0  6,
 *           A                0
 *        F     B         32     2
 *           G               64
 *        E     C         16     4
 *           D                8
 *       on peut aussi utiliser les mnemos : 
 *       SEG_A, SEG_B, SEG_C, SEG D, SEG E, SEG F, SEG G  */
   void affSeg(uint8_t,uint8_t pos);
 /** Affiche ou non le symbole deux-points selon que le parametre b vaut true ou false*/
    void affPoint(uint8_t b);
 /** Affiche un caractere
* Parametres:  
* c caractere Ascii a afficher [' ','~'] codes entre 32 et 127   
* pos : numero de l'afficheur 0 (le plus a gauche) a 3 (le plus a droite)*/
    void affChar(char c,uint8_t pos);
 /** Modifie la luminosite de 0 a 7 */
void setBrillance(uint8_t luminosite);    
 /** Affiche une chaine de caracteres.
 *Si la longueur de la chaine est > 4 seuls les 4 premiers caracteres sont affiches
 *Si la longueur de la chaine est < 4 l'affichage est complete par des espaces*/
void affString(const char t[]);
 /** efface l'ecran */
void clear();
 /** affiche un entier compris entre 0 et 9999
 * si la valeur < 0 ou valeur > 9999, affiche EEEE */
void affInt(int valeur);
protected:
   void bitDelay();
   void start();
   void stop();
   bool writeByte(uint8_t b);
   void setBrightness(uint8_t brightness, bool on = true);
   void setSegments(const uint8_t segments[], uint8_t length = 4, uint8_t pos = 0);
private:
	uint8_t m_pinClk;
	uint8_t m_pinDIO;
	uint8_t m_brightness;
     uint8_t seg1;
     uint8_t bpoint;
};
#endif // __ggtm1637__
