extern "C" 
{
  #include <stdlib.h>
  #include <string.h>
  #include <inttypes.h>
}

#include <ggtm1637.h>
#include <Arduino.h>

#define TM1637_I2C_COMM1    0x40
#define TM1637_I2C_COMM2    0xC0
#define TM1637_I2C_COMM3    0x80

//
//      A
//     ---
//  F |   | B
//     -G-
//  E |   | C
//     ---
//      D
/*
const uint8_t digitToSegment[] = 
{
 // XGFEDCBA
  0b00111111,    // 0
  0b00000110,    // 1
  0b01011011,    // 2
  0b01001111,    // 3
  0b01100110,    // 4
  0b01101101,    // 5
  0b01111101,    // 6
  0b00000111,    // 7
  0b01111111,    // 8
  0b01101111,    // 9
  0b01110111,    // A
  0b01111100,    // b
  0b00111001,    // C
  0b01011110,    // d
  0b01111001,    // E
  0b01110001     // F
  };
*/
// ASCII MAPPINGS
#define TM1637_CHAR_SPACE       B00000000 // 32  (ASCII)
#define TM1637_CHAR_EXC         B00000110
#define TM1637_CHAR_D_QUOTE     B00100010
#define TM1637_CHAR_POUND       B01110110
#define TM1637_CHAR_DOLLAR      B01101101
#define TM1637_CHAR_PERC        B00100100
#define TM1637_CHAR_AMP         B01111111
#define TM1637_CHAR_S_QUOTE     B00100000
#define TM1637_CHAR_L_BRACKET   B00111001
#define TM1637_CHAR_R_BRACKET   B00001111
#define TM1637_CHAR_STAR        B01011100
#define TM1637_CHAR_PLUS        B01010000
#define TM1637_CHAR_COMMA       B00010000
#define TM1637_CHAR_MIN         B01000000
#define TM1637_CHAR_DOT         B00001000
#define TM1637_CHAR_F_SLASH     B00000110
#define TM1637_CHAR_0           B00111111   // 48
#define TM1637_CHAR_1           B00000110
#define TM1637_CHAR_2           B01011011
#define TM1637_CHAR_3           B01001111
#define TM1637_CHAR_4           B01100110
#define TM1637_CHAR_5           B01101101
#define TM1637_CHAR_6           B01111101
#define TM1637_CHAR_7           B00000111
#define TM1637_CHAR_8           B01111111
#define TM1637_CHAR_9           B01101111
#define TM1637_CHAR_COLON       B00110000
#define TM1637_CHAR_S_COLON     B00110000
#define TM1637_CHAR_LESS        B01011000
#define TM1637_CHAR_EQUAL       B01001000
#define TM1637_CHAR_GREAT       B01001100
#define TM1637_CHAR_QUEST       B01010011
#define TM1637_CHAR_AT          B01011111
#define TM1637_CHAR_A           B01110111 // 65  (ASCII)
#define TM1637_CHAR_B           B01111111
#define TM1637_CHAR_C           B00111001
#define TM1637_CHAR_D           TM1637_CHAR_d
#define TM1637_CHAR_E           B01111001
#define TM1637_CHAR_F           B01110001
#define TM1637_CHAR_G           B00111101
#define TM1637_CHAR_H           B01110110
#define TM1637_CHAR_I           B00000110
#define TM1637_CHAR_J           B00001110
#define TM1637_CHAR_K           B01110101
#define TM1637_CHAR_L           B00111000
#define TM1637_CHAR_M           B00010101
#define TM1637_CHAR_N           B00110111
#define TM1637_CHAR_O           B00111111
#define TM1637_CHAR_P           B01110011
#define TM1637_CHAR_Q           B01100111
#define TM1637_CHAR_R           B00110011
#define TM1637_CHAR_S           B01101101
#define TM1637_CHAR_T           TM1637_CHAR_t
#define TM1637_CHAR_U           B00111110
#define TM1637_CHAR_V           B00011100
#define TM1637_CHAR_W           B00101010
#define TM1637_CHAR_X           TM1637_CHAR_H
#define TM1637_CHAR_Y           B01101110
#define TM1637_CHAR_Z           B01011011
#define TM1637_CHAR_L_S_BRACKET B00111001 // 91 (ASCII)
#define TM1637_CHAR_B_SLASH     B00110000
#define TM1637_CHAR_R_S_BRACKET B00001111
#define TM1637_CHAR_A_CIRCUM    B00010011
#define TM1637_CHAR_UNDERSCORE  B00001000
#define TM1637_CHAR_A_GRAVE     B00010000
#define TM1637_CHAR_a           B01011111 // 97 (ASCII)
#define TM1637_CHAR_b           B01111100
#define TM1637_CHAR_c           B01011000
#define TM1637_CHAR_d           B01011110
#define TM1637_CHAR_e           B01111011
#define TM1637_CHAR_f           TM1637_CHAR_F
#define TM1637_CHAR_g           B01101111
#define TM1637_CHAR_h           B01110100
#define TM1637_CHAR_i           B00000100
#define TM1637_CHAR_j           B00001100
#define TM1637_CHAR_k           TM1637_CHAR_K
#define TM1637_CHAR_l           B00110000
#define TM1637_CHAR_m           TM1637_CHAR_M
#define TM1637_CHAR_n           B01010100
#define TM1637_CHAR_o           B01011100
#define TM1637_CHAR_p           TM1637_CHAR_P
#define TM1637_CHAR_q           TM1637_CHAR_Q
#define TM1637_CHAR_r           B01010000
#define TM1637_CHAR_s           TM1637_CHAR_S
#define TM1637_CHAR_t           B01111000
#define TM1637_CHAR_u           B00011100
#define TM1637_CHAR_v           B00011100
#define TM1637_CHAR_w           TM1637_CHAR_W
#define TM1637_CHAR_x           TM1637_CHAR_X
#define TM1637_CHAR_y           B01100110
#define TM1637_CHAR_z           TM1637_CHAR_Z
#define TM1637_CHAR_L_ACCON     B01111001 // 123 (ASCII)
#define TM1637_CHAR_BAR         B00000110
#define TM1637_CHAR_R_ACCON     B01001111
#define TM1637_CHAR_TILDE       B01000000 // 126 (ASCII)
// store an ASCII Map in PROGMEM (Flash memory)
const PROGMEM uint8_t asciiMap[96] = {
  TM1637_CHAR_SPACE,
  TM1637_CHAR_EXC,
  TM1637_CHAR_D_QUOTE,
  TM1637_CHAR_POUND,
  TM1637_CHAR_DOLLAR,
  TM1637_CHAR_PERC,
  TM1637_CHAR_AMP,
  TM1637_CHAR_S_QUOTE,
  TM1637_CHAR_L_BRACKET,
  TM1637_CHAR_R_BRACKET,
  TM1637_CHAR_STAR,
  TM1637_CHAR_PLUS,
  TM1637_CHAR_COMMA,
  TM1637_CHAR_MIN,
  TM1637_CHAR_DOT,
  TM1637_CHAR_F_SLASH,
  TM1637_CHAR_0,          // 48 (ASCII)
  TM1637_CHAR_1,
  TM1637_CHAR_2,
  TM1637_CHAR_3,
  TM1637_CHAR_4,
  TM1637_CHAR_5,
  TM1637_CHAR_6,
  TM1637_CHAR_7,
  TM1637_CHAR_8,
  TM1637_CHAR_9,
  TM1637_CHAR_COLON,
  TM1637_CHAR_S_COLON,
  TM1637_CHAR_LESS,
  TM1637_CHAR_EQUAL,
  TM1637_CHAR_GREAT,
  TM1637_CHAR_QUEST,
  TM1637_CHAR_AT,
  TM1637_CHAR_A,          // 65 (ASCII)
  TM1637_CHAR_B,
  TM1637_CHAR_C,
  TM1637_CHAR_D,
  TM1637_CHAR_E,
  TM1637_CHAR_F,
  TM1637_CHAR_G,
  TM1637_CHAR_H,
  TM1637_CHAR_I,
  TM1637_CHAR_J,
  TM1637_CHAR_K,
  TM1637_CHAR_L,
  TM1637_CHAR_M,
  TM1637_CHAR_N,
  TM1637_CHAR_O,
  TM1637_CHAR_P,
  TM1637_CHAR_Q,
  TM1637_CHAR_R,
  TM1637_CHAR_S,
  TM1637_CHAR_T,
  TM1637_CHAR_U,
  TM1637_CHAR_V,
  TM1637_CHAR_W,
  TM1637_CHAR_X,
  TM1637_CHAR_Y,
  TM1637_CHAR_Z,
  TM1637_CHAR_L_S_BRACKET,  // 91 (ASCII)
  TM1637_CHAR_B_SLASH,
  TM1637_CHAR_R_S_BRACKET,
  TM1637_CHAR_A_CIRCUM,
  TM1637_CHAR_UNDERSCORE,
  TM1637_CHAR_A_GRAVE,       // 96 (ASCII)
  TM1637_CHAR_a,
  TM1637_CHAR_b,
  TM1637_CHAR_c,
  TM1637_CHAR_d,
  TM1637_CHAR_e,
  TM1637_CHAR_f,
  TM1637_CHAR_g,
  TM1637_CHAR_h,
  TM1637_CHAR_i,
  TM1637_CHAR_j,
  TM1637_CHAR_k,
  TM1637_CHAR_l,
  TM1637_CHAR_m,
  TM1637_CHAR_n,
  TM1637_CHAR_o,
  TM1637_CHAR_p,
  TM1637_CHAR_q,
  TM1637_CHAR_r,
  TM1637_CHAR_s,
  TM1637_CHAR_t,
  TM1637_CHAR_u,
  TM1637_CHAR_v,
  TM1637_CHAR_w,
  TM1637_CHAR_x,
  TM1637_CHAR_y,
  TM1637_CHAR_z,
  TM1637_CHAR_L_ACCON,  // 123 (ASCII)
  TM1637_CHAR_BAR,
  TM1637_CHAR_R_ACCON,
  TM1637_CHAR_TILDE     // 126 (ASCII)
};

ggtm1637::ggtm1637(uint8_t pinClk, uint8_t pinDIO)
{
	m_pinClk = pinClk;
	m_pinDIO = pinDIO;
    pinMode(m_pinClk, INPUT);
    pinMode(m_pinDIO,INPUT);
	digitalWrite(m_pinClk, LOW);
	digitalWrite(m_pinDIO, LOW);
}

void ggtm1637::setBrightness(uint8_t brightness, bool on)
{
	m_brightness = (brightness & 0x7) | (on? 0x08 : 0x00);
}

void ggtm1637::setSegments(const uint8_t segments[], uint8_t length, uint8_t pos)
{
     // Write COMM1
	start();
	writeByte(TM1637_I2C_COMM1);
	stop();
	// Write COMM2 + first digit address
	start();
	writeByte(TM1637_I2C_COMM2 + (pos & 0x03));
	// Write the data bytes
	for (uint8_t k=0; k < length; k++) writeByte(segments[k]);
	stop();
	// Write COMM3 + brightness
	start();
	writeByte(TM1637_I2C_COMM3 + (m_brightness & 0x0f));
	stop();
}

void ggtm1637::bitDelay()
{
	delayMicroseconds(100);
}

void ggtm1637::start()
{
  pinMode(m_pinDIO, OUTPUT);
  bitDelay();
}

void ggtm1637::stop()
{
	pinMode(m_pinDIO, OUTPUT);
	bitDelay();
	pinMode(m_pinClk, INPUT);
	bitDelay();
	pinMode(m_pinDIO, INPUT);
	bitDelay();
}

bool ggtm1637::writeByte(uint8_t b)
{
  uint8_t data = b;
  // 8 Data Bits
  for(uint8_t i = 0; i < 8; i++) 
  {
    // CLK low
    pinMode(m_pinClk, OUTPUT);
    bitDelay();
	// Set data bit
    if (data & 0x01)
      pinMode(m_pinDIO, INPUT);
    else
      pinMode(m_pinDIO, OUTPUT);
    bitDelay();
	// CLK high
    pinMode(m_pinClk, INPUT);
    bitDelay();
    data = data >> 1;
  }
  // Wait for acknowledge
  // CLK to zero
  pinMode(m_pinClk, OUTPUT);
  pinMode(m_pinDIO, INPUT);
  bitDelay();
  // CLK to high
  pinMode(m_pinClk, INPUT);
  bitDelay();
  uint8_t ack = digitalRead(m_pinDIO);
  if (ack == 0)pinMode(m_pinDIO, OUTPUT);
  bitDelay();
  pinMode(m_pinClk, OUTPUT);
  bitDelay();
  return ack;
}
/*
uint8_t ggtm1637::encodeDigit(uint8_t digit)
{
	return digitToSegment[digit & 0x0f];
}
*/
//------------- GG -----------------
void ggtm1637::affSeg(uint8_t  seg,uint8_t  pos)
{
  uint8_t d[1];
  d[0] = seg;
  if (pos == 1)
  {
    seg1 = seg;
    if (bpoint) d[0] |= 0x80;
  }
 setSegments(d, 1, pos);
}

void ggtm1637::affPoint(uint8_t  b)
{
 bpoint = b;
 affSeg(seg1, 1);
}

void ggtm1637::affChar(char c,uint8_t pos)
{
 if(c<' ' || c>126) affChar(' ',pos);
 else affSeg(pgm_read_byte_near(asciiMap + c - ' '), pos);
}

void ggtm1637::affString(const char t[])
{
 int i,n;
 n=strlen(t);
 if(n>4) n=4;
 for(i=0;i<n;i++) affChar(t[i],i);
 while(i<4)
 { 
  affChar(' ',i);
  i++;
 }
}

void ggtm1637::setBrillance(uint8_t  luminosite)
{
 setBrightness(luminosite,true);
}

void ggtm1637::clear()
{
 affString("    ");
}

void ggtm1637::affInt(int valeur)
{
 char t[5];
 if(valeur<0 || valeur>9999) affString("EEEE");
 else
 {
  sprintf(t,"%04d",valeur);
  affString(t);
 }
}
