#include <Arduino.h>
#include "Thermistor.h"
float Thermistor::getTemp(int THERMISTORPIN)
/*
   Retourne la temperature en degres celsius detectee
   sur la broche analogique THERMISTORPIN
   Fontionnne avec un thermistor 10k
   Schema:
   (+5V) ---- (10k-Resistor) -------|------- (Thermistor) ---- (Ground)
                                    |
                                Analog Pin 0

*/
{
  float valeur, steinhart;
  float SERIESRESISTOR = 10000;    // valeur de la resistance utilisee en ohms
  float THERMISTORNOMINAL = 10000; // valeur du thermistor en ohms
  float BCOEFFICIENT = 3950;       // The beta coefficient of the thermistor 
                                   //(usually 3000-4000)
  float TEMPERATURENOMINAL = 25;   // temp. for nominal resistance 
                                   // (almost always 25 C)
  valeur = analogRead(THERMISTORPIN);
  valeur = 1023 / valeur - 1;
  valeur = SERIESRESISTOR / valeur;
  // formule de steinhart
  steinhart = valeur / THERMISTORNOMINAL;         // (R/Ro)
  steinhart = log(steinhart);                     // ln(R/Ro)
  steinhart /= BCOEFFICIENT;                      // 1/B * ln(R/Ro)
  steinhart += 1.0 / (TEMPERATURENOMINAL + 273.15); // + (1/To)
  steinhart = 1.0 / steinhart;                    // Invert
  steinhart -= 273.15;                            // convert to C
  return steinhart;
}
